<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Settings;

class AdminSettingsController extends Controller
{
    //
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = Settings::get();
    
        return view('admin.settings.index',compact('data'));
    }

    public function update(Request $request)
    {
        $setting = [
            'referral_earning', 'hcaptcha_key', 'hcaptcha_secret', 'level_1', 'level_2', 'level_3', 
            'level_4', 'level_5', 'level_6', 'level_7', 'level_8', 'level_9', 'level_10', 'staking_apikey', 'proxycheck', 'block_vpnlogin',
            'fp_username', 'daily_bonus',
        ];

        $requestData = $request->all();

        foreach ($setting as $key) {
            $newValue = $requestData[$key];
            $updt = Settings::where('name', $key);
            $updt->update(['value' => $newValue]);
        }

        return redirect()->back()
                        ->with('success','Updated successfully.');
    }

}
